//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.components](index.md)/[ChatList](-chat-list.md)

# ChatList

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [ChatList](-chat-list.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, header: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, emptyState: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { EmptyListView(config = BotStacks.assets.emptyChats)  }, filter: ([Chat](../ai.botstacks.sdk.state/-chat/index.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = { true }, onChatClicked: ([Chat](../ai.botstacks.sdk.state/-chat/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))

ChatList

Renders a given list of [Chat](../ai.botstacks.sdk.state/-chat/index.md) in an infinite scrolling list. Each chat will render a preview of it using [ChatMessagePreview](-chat-message-preview.md).

#### Parameters

common

| | |
|---|---|
| modifier | the Modifier to be applied to this ChatList |
| header | Optional header to display, fixed, at the top of the list. Normally this would be a [Header](-header.md). |
| emptyState | Optional UI state for when there is no chats available. See [ai.botstacks.sdk.ui.theme.Assets](../ai.botstacks.sdk.ui.theme/-assets/index.md) and [ai.botstacks.sdk.ui.theme.EmptyScreenConfig](../ai.botstacks.sdk.ui.theme/-empty-screen-config/index.md) |
| filter | predicate to filter the chats that are loaded. This is generally done from search in [Header](-header.md). |
| onChatClicked | callback for when a [Chat](../ai.botstacks.sdk.state/-chat/index.md) in the list is clicked. |
